/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.DToA;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

final class NativeNumber
extends IdScriptableObject {
    static final long serialVersionUID = 3504516769741512101L;
    private static final Object NUMBER_TAG = "Number";
    private static final int MAX_PRECISION = 100;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_toSource = 4;
    private static final int Id_valueOf = 5;
    private static final int Id_toFixed = 6;
    private static final int Id_toExponential = 7;
    private static final int Id_toPrecision = 8;
    private static final int MAX_PROTOTYPE_ID = 8;
    private double doubleValue;

    static void init(Scriptable scope, boolean sealed) {
        NativeNumber obj = new NativeNumber(0.0);
        obj.exportAsJSClass(8, scope, sealed);
    }

    NativeNumber(double number2) {
        this.doubleValue = number2;
    }

    public String getClassName() {
        return "Number";
    }

    protected void fillConstructorProperties(IdFunctionObject ctor) {
        int attr = 7;
        ctor.defineProperty("NaN", ScriptRuntime.NaNobj, 7);
        ctor.defineProperty("POSITIVE_INFINITY", ScriptRuntime.wrapNumber(Double.POSITIVE_INFINITY), 7);
        ctor.defineProperty("NEGATIVE_INFINITY", ScriptRuntime.wrapNumber(Double.NEGATIVE_INFINITY), 7);
        ctor.defineProperty("MAX_VALUE", ScriptRuntime.wrapNumber(Double.MAX_VALUE), 7);
        ctor.defineProperty("MIN_VALUE", ScriptRuntime.wrapNumber(Double.MIN_VALUE), 7);
        super.fillConstructorProperties(ctor);
    }

    protected void initPrototypeId(int id) {
        String s2;
        int arity;
        switch (id) {
            case 1: {
                arity = 1;
                s2 = "constructor";
                break;
            }
            case 2: {
                arity = 1;
                s2 = "toString";
                break;
            }
            case 3: {
                arity = 1;
                s2 = "toLocaleString";
                break;
            }
            case 4: {
                arity = 0;
                s2 = "toSource";
                break;
            }
            case 5: {
                arity = 0;
                s2 = "valueOf";
                break;
            }
            case 6: {
                arity = 1;
                s2 = "toFixed";
                break;
            }
            case 7: {
                arity = 1;
                s2 = "toExponential";
                break;
            }
            case 8: {
                arity = 1;
                s2 = "toPrecision";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(id));
            }
        }
        this.initPrototypeMethod(NUMBER_TAG, id, s2, arity);
    }

    public Object execIdCall(IdFunctionObject f2, Context cx, Scriptable scope, Scriptable thisObj, Object[] args2) {
        if (!f2.hasTag(NUMBER_TAG)) {
            return super.execIdCall(f2, cx, scope, thisObj, args2);
        }
        int id = f2.methodId();
        if (id == 1) {
            double val;
            double d = val = args2.length >= 1 ? ScriptRuntime.toNumber(args2[0]) : 0.0;
            if (thisObj == null) {
                return new NativeNumber(val);
            }
            return ScriptRuntime.wrapNumber(val);
        }
        if (!(thisObj instanceof NativeNumber)) {
            throw NativeNumber.incompatibleCallError(f2);
        }
        double value2 = ((NativeNumber)thisObj).doubleValue;
        switch (id) {
            case 2: 
            case 3: {
                int base = args2.length == 0 || args2[0] == Undefined.instance ? 10 : ScriptRuntime.toInt32(args2[0]);
                return ScriptRuntime.numberToString(value2, base);
            }
            case 4: {
                return "(new Number(" + ScriptRuntime.toString(value2) + "))";
            }
            case 5: {
                return ScriptRuntime.wrapNumber(value2);
            }
            case 6: {
                return NativeNumber.num_to(value2, args2, 2, 2, -20, 0);
            }
            case 7: {
                if (Double.isNaN(value2)) {
                    return "NaN";
                }
                if (Double.isInfinite(value2)) {
                    if (value2 >= 0.0) {
                        return "Infinity";
                    }
                    return "-Infinity";
                }
                return NativeNumber.num_to(value2, args2, 1, 3, 0, 1);
            }
            case 8: {
                if (args2.length == 0 || args2[0] == Undefined.instance) {
                    return ScriptRuntime.numberToString(value2, 10);
                }
                if (Double.isNaN(value2)) {
                    return "NaN";
                }
                if (Double.isInfinite(value2)) {
                    if (value2 >= 0.0) {
                        return "Infinity";
                    }
                    return "-Infinity";
                }
                return NativeNumber.num_to(value2, args2, 0, 4, 1, 0);
            }
        }
        throw new IllegalArgumentException(String.valueOf(id));
    }

    public String toString() {
        return ScriptRuntime.numberToString(this.doubleValue, 10);
    }

    private static String num_to(double val, Object[] args2, int zeroArgMode, int oneArgMode, int precisionMin, int precisionOffset) {
        int precision;
        if (args2.length == 0) {
            precision = 0;
            oneArgMode = zeroArgMode;
        } else {
            precision = ScriptRuntime.toInt32(args2[0]);
            if (precision < precisionMin || precision > 100) {
                String msg = ScriptRuntime.getMessage1("msg.bad.precision", ScriptRuntime.toString(args2[0]));
                throw ScriptRuntime.constructError("RangeError", msg);
            }
        }
        StringBuilder sb = new StringBuilder();
        DToA.JS_dtostr(sb, oneArgMode, precision + precisionOffset, val);
        return sb.toString();
    }

    protected int findPrototypeId(String s2) {
        int id;
        block10: {
            id = 0;
            String X = null;
            switch (s2.length()) {
                case 7: {
                    char c = s2.charAt(0);
                    if (c == 't') {
                        X = "toFixed";
                        id = 6;
                        break;
                    }
                    if (c != 'v') break;
                    X = "valueOf";
                    id = 5;
                    break;
                }
                case 8: {
                    char c = s2.charAt(3);
                    if (c == 'o') {
                        X = "toSource";
                        id = 4;
                        break;
                    }
                    if (c != 't') break;
                    X = "toString";
                    id = 2;
                    break;
                }
                case 11: {
                    char c = s2.charAt(0);
                    if (c == 'c') {
                        X = "constructor";
                        id = 1;
                        break;
                    }
                    if (c != 't') break;
                    X = "toPrecision";
                    id = 8;
                    break;
                }
                case 13: {
                    X = "toExponential";
                    id = 7;
                    break;
                }
                case 14: {
                    X = "toLocaleString";
                    id = 3;
                    break;
                }
            }
            if (X == null || X == s2 || X.equals(s2)) break block10;
            id = 0;
        }
        return id;
    }
}

